<?php
/**
 * Mark Module
 *
 * @package     AutomatorWP\Integrations\Thrive_Apprentice\Actions\Mark_Module
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Thrive_Apprentice_Mark_Module extends AutomatorWP_Integration_Action {

    public $integration = 'thrive_apprentice';
    public $action = 'thrive_apprentice_mark_module';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Mark module as completed for the user', 'automatorwp-pro' ),
            'select_option'     => __( 'Mark <strong>module as completed</strong> for the user', 'automatorwp-pro' ),
            /* translators: %1$s: Module title. */
            'edit_label'        => sprintf( __( 'Mark %1$s as completed for the user', 'automatorwp-pro' ), '{post}' ),
            /* translators: %1$s: Module title. */
            'log_label'         => sprintf( __( 'Mark %1$s as completed for the user', 'automatorwp-pro' ), '{post}' ),
            'options'           => array(
                'post' => array(
                    'from' => 'module',
                    'default' => __( 'module', 'automatorwp-pro' ),
                    'fields' => array(
                        'course' => automatorwp_utilities_term_field( array(
                            'name'              => __( 'Course:', 'automatorwp-pro' ),
                            'placeholder'       => __( 'Select a course', 'automatorwp-pro' ),
                            'option_none'       => false,
                            'option_custom_desc'    => __( 'Course ID', 'automatorwp-pro' ),
                            'taxonomy' => 'tva_courses',
                        ) ),
                        'module' => automatorwp_utilities_ajax_selector_field( array(
                            'option_none' => false,
                            'option_custom' => false,
                            'placeholder'       => __( 'Select a module', 'automatorwp-pro' ),
                            'name' => __( 'Modules:', 'automatorwp-pro' ),
                            'action_cb' => 'automatorwp_thrive_apprentice_get_modules',
                            'options_cb' => 'automatorwp_thrive_apprentice_options_cb_modules',
                            'default' => ''
                        ) ),
                    )
                ),
            ),
        ) );

    }


    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $module_id = absint( $action_options['module'] );
        $course_id = absint( $action_options['course'] );
        
        // Bail if not module provided
        if( $module_id === 0 ) {
            return;
        }

        // Bail if not course provided
        if( $course_id === 0 ) {
            return;
        }

        // Get lessons from module
        $module_lessons = get_children( array(
            'post_parent' => $module_id,
            'post_type'   => 'tva_lesson',
            'post_status' => 'publish',
        ) );

        // Complete all lessons from the module
        foreach ( $module_lessons as $lesson ){

            $learned = get_user_meta( $user_id, 'tva_learned_lessons', true );

            if ( ! is_array( $learned ) ) {
                $learned = array();
            }

            if ( ! isset( $learned[$course_id] ) || ! is_array( $learned[$course_id] ) ) {
                $learned[$course_id] = array();
            }

            // Mark lesson as completed
            $learned[$course_id][$lesson->ID] = 1;

            // Update meta
            update_user_meta( $user_id, 'tva_learned_lessons', $learned );

        }

    }

}

new AutomatorWP_Thrive_Apprentice_Mark_Module();